/* JAlbum tool that converts jAlbum project format from pre v16 format to current format */

import se.datadosen.jalbum.*;
import se.datadosen.util.IO;

Work.on(TreeCollection.of(rootFolder))
.titled("Convert project from pre 16 format")
.inform("This tool converts this album project from pre v16 format. Don't run on jAlbum 16+ projects")
.filter(ao -> ao.folder)
.forEach(folder) -> {
	File dir = folder.file;
	File jAlbumDir = new File(dir, ".jalbum");
	jAlbumDir.mkdirs();
	IO.move(new File(dir, "meta.properties"), jAlbumDir);
	IO.move(new File(dir, "comments.properties"), jAlbumDir);
	IO.move(new File(dir, "albumfiles.txt"), jAlbumDir);	
}.execute(work) -> {
	if (!work.cancelled) {
		// Refresh display
		rootFolder.invalidate();
		explorer.context.redraw();			
	}
}.showResult()
